/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util.collections;

import com.alcatrazescapee.alcatrazcore.util.collections.EnumTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ImmutableEnumTable<R extends Enum<R>, C extends Enum<C>, V>
extends EnumTable<R, C, V> {
    private ImmutableEnumTable(EnumMap<R, EnumMap<C, V>> table, Class<R> rowClass, Class<C> colClass) {
        super(table, rowClass, colClass);
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    @Deprecated
    public V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    @Deprecated
    public V remove(@Nullable Object rowKey, @Nullable Object columnKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ImmutableMap<C, V> row(R rowKey) {
        EnumMap map = (EnumMap)this.table.get(rowKey);
        return map == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)map);
    }

    @Override
    @Nonnull
    public ImmutableMap<R, V> column(C columnKey) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.table.forEach((r, c) -> {
            Object v = c.get(columnKey);
            if (v != null) {
                b.put(r, v);
            }
        });
        return b.build();
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)this.table.entrySet().stream().map(r -> ((EnumMap)r.getValue()).entrySet().stream().map(c -> Tables.immutableCell(r.getKey(), c.getKey(), c.getValue())).collect(Collectors.toSet())).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return ImmutableSet.copyOf(this.table.keySet());
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return ImmutableSet.copyOf((Collection)((Collection)this.table.values().stream().flatMap(x -> x.keySet().stream()).collect(ImmutableSet.toImmutableSet())));
    }

    @Override
    public ImmutableSet<V> values() {
        return (ImmutableSet)this.table.values().stream().flatMap(x -> x.values().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.copyOf((Map)this.table);
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Enum c : this.columnKeySet()) {
            b.put((Object)c, this.column((C)c));
        }
        return b.build();
    }

    public static class Builder<R extends Enum<R>, C extends Enum<C>, V> {
        private final EnumMap<R, EnumMap<C, V>> table;
        private final Class<C> colClass;
        private final Class<R> rowClass;

        public Builder(Class<R> rowClass, Class<C> colClass) {
            this.colClass = colClass;
            this.rowClass = rowClass;
            this.table = new EnumMap(rowClass);
        }

        @Nullable
        public V put(R rowKey, C columnKey, V value) {
            EnumMap<C, V> map = this.table.get(rowKey);
            if (map == null) {
                map = new EnumMap(this.colClass);
                map.put(columnKey, value);
                this.table.put(rowKey, map);
                return null;
            }
            V old = map.get(columnKey);
            map.put(columnKey, value);
            return old;
        }

        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            table.rowMap().forEach((r, x) -> x.forEach((c, v) -> this.put(r, c, v)));
        }

        public ImmutableEnumTable<R, C, V> build() {
            return new ImmutableEnumTable(this.table, this.rowClass, this.colClass);
        }
    }
}

